package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.RequerimientoOS2Dao;
import com.ejie.ab04b.model.RequerimientoOS2;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0447s00ServiceImpl generated by UDA, 31-may-2017 9:30:50.
 * 
 * @author UDA
 */

@Service(value = "requerimientoOS2ServiceImpl")
public class RequerimientoOS2ServiceImpl implements RequerimientoOS2Service {

	@Autowired
	private RequerimientoOS2Dao ab0447s00Dao;

	/**
	 * Inserts a single row in the Ab0447s00 table.
	 * 
	 * ab0447s00 Ab0447s00 Ab0447s00
	 * 
	 * @param ab0447s00
	 *            the ab 0447 s 00
	 * @return the requerimiento OS 2
	 */
	@Transactional(rollbackFor = Throwable.class)
	public RequerimientoOS2 add(RequerimientoOS2 ab0447s00) {
		return this.ab0447s00Dao.add(ab0447s00);
	}

	/**
	 * Updates a single row in the Ab0447s00 table.
	 * 
	 * ab0447s00 Ab0447s00 Ab0447s00
	 * 
	 * @param ab0447s00
	 *            the ab 0447 s 00
	 * @return the requerimiento OS 2
	 */
	@Transactional(rollbackFor = Throwable.class)
	public RequerimientoOS2 update(RequerimientoOS2 ab0447s00) {
		return this.ab0447s00Dao.update(ab0447s00);
	}

	/**
	 * Finds a single row in the Ab0447s00 table.
	 * 
	 * ab0447s00 Ab0447s00 Ab0447s00
	 * 
	 * @param ab0447s00
	 *            the ab 0447 s 00
	 * @return the requerimiento OS 2
	 */
	public RequerimientoOS2 find(RequerimientoOS2 ab0447s00) {
		return (RequerimientoOS2) this.ab0447s00Dao.find(ab0447s00);
	}

	/**
	 * Deletes a single row in the Ab0447s00 table.
	 * 
	 * ab0447s00 Ab0447s00
	 * 
	 * @param ab0447s00
	 *            the ab 0447 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(RequerimientoOS2 ab0447s00) {
		this.ab0447s00Dao.remove(ab0447s00);
	}

	/**
	 * Finds a list of rows in the Ab0447s00 table.
	 * 
	 * ab0447s00 Ab0447s00 jqGridRequestDto JQGridRequestDto List<Ab0447s00>
	 * 
	 * @param ab0447s00
	 *            the ab 0447 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	public List<RequerimientoOS2> findAll(RequerimientoOS2 ab0447s00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<RequerimientoOS2>) this.ab0447s00Dao.findAll(ab0447s00,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab0447s00 table using like.
	 * 
	 * ab0447s00 Ab0447s00 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<Ab0447s00>
	 * 
	 * @param ab0447s00
	 *            the ab 0447 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	public List<RequerimientoOS2> findAllLike(RequerimientoOS2 ab0447s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<RequerimientoOS2>) this.ab0447s00Dao.findAllLike(
				ab0447s00, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab0447s00 table.
	 * 
	 * filterAb0447s00 Ab0447s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean
	 * 
	 * @param filterAb0447s00
	 *            the filter ab 0447 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 */
	public void removeMultiple(RequerimientoOS2 filterAb0447s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.ab0447s00Dao.removeMultiple(filterAb0447s00, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the Ab0447s00 table.
	 * 
	 * filterAb0447s00 Ab0447s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean JQGridResponseDto<Ab0447s00>
	 * 
	 * @param filterAb0447s00
	 *            the filter ab 0447 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<RequerimientoOS2> filter(
			RequerimientoOS2 filterAb0447s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<RequerimientoOS2> listaAb0447s00 = this.ab0447s00Dao.findAllLike(
				filterAb0447s00, jqGridRequestDto, false);
		Long recordNum = this.ab0447s00Dao.findAllLikeCount(
				filterAb0447s00 != null ? filterAb0447s00
						: new RequerimientoOS2(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<RequerimientoOS2>> reorderSelection = this.ab0447s00Dao
					.reorderSelection(filterAb0447s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<RequerimientoOS2>(jqGridRequestDto,
					recordNum, listaAb0447s00, reorderSelection);
		}
		return new JQGridResponseDto<RequerimientoOS2>(jqGridRequestDto,
				recordNum, listaAb0447s00);
	}

	/**
	 * Searches rows in the Ab0447s00 table.
	 * 
	 * filterAb0447s00 Ab0447s00 searchAb0447s00 Ab0447s00 jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto<Ab0447s00>>
	 * 
	 * @param filterAb0447s00
	 *            the filter ab 0447 s 00
	 * @param searchAb0447s00
	 *            the search ab 0447 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	public List<TableRowDto<RequerimientoOS2>> search(
			RequerimientoOS2 filterAb0447s00, RequerimientoOS2 searchAb0447s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0447s00Dao.search(filterAb0447s00, searchAb0447s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab0447s00 table.
	 * 
	 * filterAb0447s00 Ab0447s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean Object
	 * 
	 * @param filterAb0447s00
	 *            the filter ab 0447 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the object
	 */
	public Object reorderSelection(RequerimientoOS2 filterAb0447s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0447s00Dao.reorderSelection(filterAb0447s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * removePorTarea
	 * 
	 * @param idTarea
	 *            Long
	 */
	@Override
	public void removePorTarea(Long idTarea) {
		this.ab0447s00Dao.removePorTarea(idTarea);
	}

}
